# Flash Courier - PHP Edition

A minimal courier transfer system in plain PHP + MySQL with:
- Thermal receipt printing optimized for 58mm/80mm
- Barcode + QR on receipts (client-side JsBarcode + QRious)
- User login and session
- Full action logging (creates, searches, prints, notifications, login/logout)
- SMS integration placeholder for NEW SOAP or HTTP POST providers

## Quick setup

1. Put project in your webroot (e.g., /var/www/html/flash-courier-php).
2. Create MySQL database and import `sql/schema.sql`:
   ```
   mysql -u root -p < sql/schema.sql
   ```
3. Edit `app/config.php` with DB credentials and SMS endpoint.
4. Run `php app/init_db.php` once to create an admin user (change password immediately).
5. Open the site in browser and login.

## Notes
- The SMS function `send_sms_newsoap()` is a placeholder that POSTs to `SMS_SOAP_ENDPOINT`. Adapt it to your provider's requirements (SOAP vs HTTP).
- Barcode and QR are rendered client-side to improve print fidelity for thermal printers.
