<?php
require_once __DIR__.'/functions.php';

function attempt_login($username, $password){
  $pdo = db();
  $stmt = $pdo->prepare('SELECT * FROM users WHERE username = ? LIMIT 1');
  $stmt->execute([$username]);
  $u = $stmt->fetch(PDO::FETCH_ASSOC);
  if($u && password_verify($password, $u['password_hash'])){
    unset($u['password_hash']);

    // Fetch location name from locations table
    $pdo = db();
    $stmt = $pdo->prepare("SELECT id, name FROM locations WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $u['location_id']]);
    $loc = $stmt->fetch(PDO::FETCH_ASSOC);

    $_SESSION['user'] = $u;
    $_SESSION['user']['location_id'] = $loc['id'] ?? 0;
    $_SESSION['user']['location_name'] = $loc['name'] ?? '-';

    log_action($u['id'], 'login', 'Successful login');
    return true;
}
  log_action(null, 'login_failed', 'Username: '.htmlspecialchars($username));
  return false;
}

function logout_action(){
  $uid = current_user_id();
  log_action($uid, 'logout', 'User logged out');
  session_destroy();
}
