<?php
require_once __DIR__.'/config.php';

function db(){
  static $pdo = null;
  if($pdo) return $pdo;
  $dsn = 'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4';
  $pdo = new PDO($dsn, DB_USER, DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
  return $pdo;
}

function log_action($user_id, $action, $detail=''){
  $pdo = db();
  $ip = $_SERVER['REMOTE_ADDR'] ?? '';
  $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
  $stmt = $pdo->prepare('INSERT INTO logs (user_id, action, detail, ip, ua) VALUES (?,?,?,?,?)');
  $stmt->execute([$user_id, $action, $detail, $ip, $ua]);
}

function require_login(){
  if(empty($_SESSION['user'])){
    header('Location: login.php'); exit;
  }
}

function current_user_id(){
  return $_SESSION['user']['id'] ?? null;
}

function gen_id(){
  return strtoupper(substr(bin2hex(random_bytes(4)),0,8));
}

function send_sms_newsoap($to, $message){
  $endpoint = SMS_SOAP_ENDPOINT;
  if(empty($endpoint)) return ['ok'=>false,'error'=>'SMS endpoint not configured'];

  $params = [
    'username' => SMS_USERNAME,
    'password' => SMS_PASSWORD,
    'from' => SMS_FROM,
    'to' => $to,
    'message' => $message
  ];

  try{
    $ch = curl_init($endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if($err) return ['ok'=>false,'error'=>$err];
    return ['ok'=>true,'resp'=>$resp,'http_code'=>$httpcode];
  }catch(Exception $e){
    return ['ok'=>false,'error'=>$e->getMessage()];
  }
}
