<?php
session_start();
require_once __DIR__.'/app/functions.php';
require_login();

$pdo = db();
$uid = current_user_id();
$username = $_SESSION['user']['username'] ?? 'Unknown';
$role = $_SESSION['user']['role'] ?? 'user';
$userphoto = $_SESSION['user']['userphoto'] ?? '';
$userImage = !empty($userphoto) && file_exists("uploads/$userphoto") ? "uploads/$userphoto" : "images/user.png";

$search = $_GET['q'] ?? '';
$courier = null;
$msg = '';

if (!empty($search)) {
    $stmt = $pdo->prepare("SELECT c.*, l.name AS destination 
                           FROM couriers c 
                           LEFT JOIN locations l ON c.receiving_at = l.id
                           WHERE c.id = :q OR c.id = :q OR c.recipient_name LIKE :like");
    $stmt->execute([':q'=>$search, ':like'=>"%$search%"]);
    $courier = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Acknowledge Arrival
if (isset($_POST['ack_id'])) {
    $cid = $_POST['ack_id'];
    $stmt = $pdo->prepare("UPDATE couriers 
                           SET arrived_at = NOW(), arrival_ack_by = :uid 
                           WHERE id = :id");
    $stmt->execute([':uid'=>$uid, ':id'=>$cid]);

    // Send SMS via your SMS API
    $recipient_phone = $_POST['recipient_phone'];
    $recipient_name = $_POST['recipient_name'];
    $destination = $_POST['destination'];
    $message = "Dear $recipient_name, your parcel has arrived at $destination. Please come to collect it. - Flash Courier";

    // Example SMS call (adjust for NEW SOAP or your SMS API)
    send_sms($recipient_phone, $message);

    $msg = "✅ Arrival acknowledged and SMS sent to recipient.";
}

// Helper for SMS
function send_sms($phone, $message){
    // Replace with your actual SMS logic (NEW SOAP)
    $url = "https://your-sms-api.example/send";
    $data = ['to'=>$phone, 'message'=>$message];
    // file_get_contents($url . '?' . http_build_query($data));
}
?>

<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Acknowledge Arrival - Flash Courier</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body { background:#f8f9fa; font-size:14px; }
header { background:#008c8c; color:#fff; }
input[type="search"]{width:250px;}
</style>
</head>
<body>

<!-- Header -->
<?php include("header.php"); ?>

<div class="container mt-3">
    <div class="card">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0">Acknowledge Parcel Arrival</h5>
        </div>
        <div class="card-body">
            <form method="get" class="d-flex gap-2 mb-3">
                <input type="search" name="q" class="form-control form-control-sm" placeholder="Search by ID, barcode or recipient name" value="<?= htmlspecialchars($search) ?>">
                <button class="btn btn-sm btn-primary">Search</button>
            </form>

            <?php if ($msg): ?>
                <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
            <?php endif; ?>

            <?php if ($courier): ?>
                <div class="card border-success">
                    <div class="card-body">
                        <h6>Courier ID: <?= htmlspecialchars($courier['id']) ?></h6>
                        <p><strong>Recipient:</strong> <?= htmlspecialchars($courier['recipient_name']) ?><br>
                           <strong>Phone:</strong> <?= htmlspecialchars($courier['recipient_phone']) ?><br>
                           <strong>Destination:</strong> <?= htmlspecialchars($courier['destination']) ?><br>
                           <strong>Status:</strong> 
                           <?php if ($courier['arrived_at']): ?>
                               <span class="text-success">Arrived on <?= htmlspecialchars($courier['arrived_at']) ?></span>
                           <?php else: ?>
                               <span class="text-danger">Not yet arrived</span>
                           <?php endif; ?>
                        </p>

                        <?php if (!$courier['arrived_at']): ?>
                        <form method="post" class="mt-3">
                            <input type="hidden" name="ack_id" value="<?= $courier['id'] ?>">
                            <input type="hidden" name="recipient_name" value="<?= htmlspecialchars($courier['recipient_name']) ?>">
                            <input type="hidden" name="recipient_phone" value="<?= htmlspecialchars($courier['recipient_phone']) ?>">
                            <input type="hidden" name="destination" value="<?= htmlspecialchars($courier['destination']) ?>">
                            <button type="submit" class="btn btn-success">Acknowledge Arrival & Notify Recipient</button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            <?php elseif($search): ?>
                <div class="alert alert-warning">No courier found for “<?= htmlspecialchars($search) ?>”.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
