<?php
session_start();
require_once __DIR__.'/app/functions.php';
require_login();

$data = json_decode(file_get_contents('php://input'), true);
if(!$data) { echo json_encode(['ok'=>false,'error'=>'Invalid JSON']); exit; }

/*function generate_barcode(){
    return 'FLC'.date('YmdHis').rand(100,999);
}*/
function generate_barcode(){
    return str_pad(rand(0, 999999999), 9, '0', STR_PAD_LEFT);
}

$id = generate_barcode();

try{
    $pdo = db();
    $stmt = $pdo->prepare("INSERT INTO couriers 
        (id, created_at,sent_time, sending_from, sender_name, sender_phone, type_id, price, receiving_at, recipient_name, recipient_phone, quantity, amount, note, created_by, sms_sent, status)
        VALUES (:id, NOW(),:sent_time ,:sending_from, :sender_name, :sender_phone, :type_id, :price, :receiving_at, :recipient_name, :recipient_phone, :quantity, :amount, :note, :created_by, 0, 'pending')
    ");
    $stmt->execute([
        ':id'=>$id,
        ':sent_time'=>$data['sending_time'],
        ':sending_from'=>$data['sending_from'],
        ':sender_name'=>$data['sender_name'],
        ':sender_phone'=>$data['sender_phone'],
        ':type_id'=>$data['type_id'],
        ':price'=>$data['price'],
        ':receiving_at'=>$data['receiving_at'],
        ':recipient_name'=>$data['recipient_name'],
        ':recipient_phone'=>$data['recipient_phone'],
        ':quantity'=>$data['quantity'],
        ':amount'=>$data['amount'],
        ':note'=>$data['note'],
        ':created_by'=>$_SESSION['user']['id']
    ]);

    $stmt2 = $pdo->prepare("
       SELECT 
  couriers.*, 
  users.id AS userid,users.fullname, 
  recv.name AS rlocation, 
  send.name AS slocation,courier_types.type_name
FROM couriers
LEFT JOIN users ON couriers.created_by = users.id
LEFT JOIN locations AS recv ON couriers.receiving_at = recv.id
LEFT JOIN locations AS send ON couriers.sending_from = send.id LEFT JOIN courier_types ON couriers.type_id=courier_types.id
        WHERE couriers.id = :id
        LIMIT 1
    ");
    $stmt2->execute([':id'=>$id]);
    $courier = $stmt2->fetch(PDO::FETCH_ASSOC);

    echo json_encode(['ok'=>true,'data'=>$courier]);

}catch(Exception $e){
    echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
