<?php
session_start();
require_once __DIR__.'/app/functions.php';
require_login();

$uid = current_user_id();
$username = $_SESSION['user']['username'] ?? 'Unknown';
$role = $_SESSION['user']['role'] ?? 'user';
$location_id = $_SESSION['user']['location_id'] ?? 0;
$location_name = $_SESSION['user']['location_name'] ?? '-';

$pdo = db();
$types = $pdo->query("SELECT id, type_name, base_price FROM courier_types ORDER BY type_name")->fetchAll(PDO::FETCH_ASSOC);
$locations = $pdo->query("SELECT id, name FROM locations ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$schtime=$pdo->query("SELECT * FROM `schedules` WHERE `desabled`='NO'")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Flash Courier Dashboard</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body {background:#f8f9fa; font-size:13px;}
header {background:#008c8c; padding:8px; color:#fff; margin-bottom:10px;}
.receipt {
  width: 88mm;
  background:#fff;
  padding:5mm;
  font-family: 'Courier New', monospace;
  font-size: 12px;
  line-height: 1.3em;
  border: 1px solid #ddd;
  margin-top: 10px;
  position: relative;
}
.watermark {
  display: none;
  position: absolute;
  top: 40%;
  left: 0;
  width: 100%;
  text-align: center;
  font-size: 24px;
  color: rgba(200, 0, 0, 0.15);
  transform: rotate(-30deg);
  font-weight: bold;
  z-index: 0;
  pointer-events: none;
}
@media print {
  body * { visibility: hidden !important; }
  #receipt, #receipt * { visibility: visible !important; }
  #receipt { position: absolute; left: 0; top: 0; width: 58mm; margin:0; padding:3mm; border:none; }
  .watermark { display: none; }
  .watermark.show-watermark { display: block !important; }
  @page { size: 58mm auto; margin: 0; }
}
</style>
</head>
<body class="p-2">


  <?php include("header.php"); ?>


<div class="container-fluid no-print">
  <div class="row">
    <div class="col-md-5">
      <!-- CREATE COURIER FORM -->
      <div class="card p-2 mb-3">
        <h6>Create Courier</h6>
        <form id="createForm">
          <input type="hidden" id="sending_from" value="<?=htmlspecialchars($location_id)?>">
          <div class="mb-1"><input id="sender_name" class="form-control form-control-sm" placeholder="Sender name" required></div>
          <div class="mb-1"><input id="sender_phone" class="form-control form-control-sm" placeholder="Sender phone" required></div>
          <div class="mb-1"><input id="recipient_name" class="form-control form-control-sm" placeholder="Recipient name" required></div>
          <div class="mb-1"><input id="recipient_phone" class="form-control form-control-sm" placeholder="Recipient phone" required></div>
          <div class="mb-1">
            <select id="type_id" class="form-control form-control-sm" required>
              <option value="">Select courier type</option>
              <?php foreach($types as $t): ?>
                <option value="<?= $t['id'] ?>" data-price="<?= $t['base_price'] ?>">
                  <?= htmlspecialchars($t['type_name']) ?> (<?= $t['base_price'] ?>)
                </option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-1"><input id="price" class="form-control form-control-sm" placeholder="Price" readonly></div>
          <div class="mb-1"><input id="quantity" class="form-control form-control-sm" placeholder="Quantity" value="1"></div>
          <div class="mb-1"><input id="amount" class="form-control form-control-sm" placeholder="Total amount" readonly></div>
          <div class="mb-1">
            <select id="receiving_at" class="form-control form-control-sm" required>
              <option value="">Select receiving location</option>
              <?php foreach($locations as $loc): ?>
                <option value="<?= $loc['id'] ?>"><?= htmlspecialchars($loc['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-1">
              <select id="sending_time" class="form-control form-control-sm" required>
              <option value="">Select time</option>
              <?php foreach($schtime as $scT): ?>
                <option value="<?= $scT['time'] ?>"><?= htmlspecialchars($scT['time']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-1"><input id="note" class="form-control form-control-sm" placeholder="Note"></div>
          <button type="submit" class="btn btn-primary btn-sm w-100">Create & Print</button>
        </form>
      </div>

      <!-- SEARCH & SMS AREA -->
      <div class="card p-2">
        <h6>Search / Scan</h6>
        <div class="input-group mb-2">
          <input id="search_id" class="form-control form-control-sm" placeholder="Enter barcode or scan">
          <button id="btnSearch" class="btn btn-outline-secondary btn-sm">Search</button>
        </div>

        <!-- SMS NOTIFY (hidden by default) -->
        <div id="notify-section" class="text-center" style="display:none;">
          <button id="notifyBtn" class="btn btn-success btn-sm">📩 Notify Recipient</button>
          <div id="smsStatus" class="small mt-1"></div>
        </div>

        <div id="searchResult"></div>
      </div>
    </div>

    <!-- RIGHT SIDE -->
    <div class="col-md-7">
      <div class="card p-2 mb-2">
        <h6>Recent Couriers</h6>
        <ul id="list" class="list-group small"></ul>
      </div>

      <!-- RECEIPT PREVIEW -->
      <div id="receipt" class="receipt" style="display:none;">
        <div id="watermark" class="watermark">NOT ORIGINAL</div>
        <div style="text-align:center;margin-bottom:5px;">
          <img src="images/logo.png" style="max-width:120px;"><br>
          <strong>FLASH COURIER</strong><br>
          <small>Fast • Secure • Reliable</small>
        </div>
        <hr>
        <div id="receiptContent" style="text-align:left;"></div>
        <hr>
        <div style="text-align:center;font-size:10px;">Thank you for choosing Flash Courier!</div>
      </div>

      <div class="no-print text-center mt-2">
        <button id="printBtn" class="btn btn-success btn-sm">🖨 Print Invoice Only</button>
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
<script>
async function api(path, opts={}){ 
  const res = await fetch(path, Object.assign({headers:{'Content-Type':'application/json'}}, opts)); 
  return res.json(); 
}

// auto price update
function updateAmount(){
  const p=parseFloat(price.value)||0, q=parseInt(quantity.value)||1;
  amount.value=(p*q).toFixed(2);
}
type_id.onchange=()=>{ 
  price.value=parseFloat(type_id.selectedOptions[0].dataset.price||0).toFixed(2); 
  updateAmount(); 
};
quantity.oninput=updateAmount;

// submit form (new courier)
createForm.onsubmit=async e=>{
  e.preventDefault();
  const data={
    sending_from:sending_from.value,
    sender_name:sender_name.value,
    sender_phone:sender_phone.value,
    recipient_name:recipient_name.value,
    recipient_phone:recipient_phone.value,
    type_id:type_id.value,
    price:price.value,
    quantity:quantity.value,
    amount:amount.value,
    receiving_at:receiving_at.value,
    sending_time:sending_time.value,
    note:note.value
  };
  const res=await api('create_courier.php',{method:'POST',body:JSON.stringify(data)});
  if(res.ok){ 
    showReceipt(res.data, false); // new courier, no watermark
    loadList(); 
    setTimeout(()=>window.print(),500); 
  } else alert(res.error||'Error creating courier');
};

let currentCourier = null;

// show receipt
function showReceipt(d, isSearched=false){
  const c=document.getElementById('receiptContent');
  const watermark = document.getElementById('watermark');
  document.getElementById('receipt').style.display='block';
  
  // set watermark only for searched couriers
  if(isSearched){
    watermark.classList.add('show-watermark');
  } else {
    watermark.classList.remove('show-watermark');
  }

  c.innerHTML=`
  <div><strong>Code:</strong> ${d.id}</div>
  <div><strong>From:</strong> ${d.slocation||'-'}</div>
  <div><strong>Sender:</strong> ${d.sender_name} (${d.sender_phone})</div>
  <div><strong>To:</strong> ${d.rlocation||'-'}</div>
  <div><strong>Recipient:</strong> ${d.recipient_name} (${d.recipient_phone})</div>
  <div><strong>Type:</strong> ${d.type_name}</div>
  <div><strong>Price:</strong> ${d.price}</div>
  <div><strong>Qty:</strong> ${d.quantity}</div>
  <div><strong>Total:</strong> ${d.amount}</div>
  <div><strong>Sending Time:</strong> ${d.sent_time}</div>
  <div><strong>Note:</strong> ${d.note||''}</div>
  <div><strong>Served by:</strong> ${d.fullname||''}</div>
  <hr>
  <div style="text-align:center;">
    <svg id="barcode"></svg><br>
    <canvas id="qrcode" style="margin-top:5px;"></canvas>
  </div>`;
  JsBarcode(document.getElementById('barcode'), d.id, {format:"CODE128", width:1, height:40, displayValue:true});
  new QRious({element:document.getElementById('qrcode'), value:d.id, size:100});
}

// search courier
btnSearch.onclick=async()=>{
  const id=search_id.value.trim(); 
  if(!id) return;
  const res=await api('get_courier.php?id='+encodeURIComponent(id));
  if(res.ok){ 
    showReceipt(res.data, true); // searched courier => watermark
    currentCourier = res.data;
    document.getElementById('notify-section').style.display='block';
    document.getElementById('smsStatus').innerText='';
  } else {
    alert('Courier not found');
    document.getElementById('notify-section').style.display='none';
  }
};

// Notify SMS
document.getElementById('notifyBtn').onclick=()=>{
  if(!currentCourier) return;
  const sms = `
Dear ${currentCourier.recipient_name},
Your parcel (${currentCourier.id}) is ready for pickup.
From: ${currentCourier.slocation}
To: ${currentCourier.rlocation}
Sender: ${currentCourier.sender_name} (${currentCourier.sender_phone})
Time: ${currentCourier.sending_time}
Thank you for using Flash Courier.`;
  document.getElementById('smsStatus').innerText='Sending...';
  fetch('send_sms.php',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({phone:currentCourier.recipient_phone,message:sms})})
  .then(r=>r.text())
  .then(t=>document.getElementById('smsStatus').innerText='✅ SMS Sent')
  .catch(e=>document.getElementById('smsStatus').innerText='❌ Failed');
};

// Print invoice
printBtn.onclick=()=>window.print();

// load recent couriers
async function loadList(){
  const res=await api('list_couriers.php');
  if(res.ok){
    list.innerHTML='';
    res.data.forEach(c=>{
      const li=document.createElement('li');
      li.className='list-group-item';
      li.innerHTML=`<strong>${c.id}</strong> — ${c.recipient_name} (${c.recipient_phone})<br><small>${c.created_at}</small>`;
      li.onclick=()=>{search_id.value=c.id; btnSearch.click();};
      list.appendChild(li);
    });
  }
}
loadList();
</script>
</body>
<?php  include 'footer.php'; ?>

</html>
