<?php
session_start();

// Assuming user data is stored in session after login
$username = $_SESSION['user']['username'] ?? 'Unknown';
$role = $_SESSION['user']['role'] ?? 'user';
$userphoto = $_SESSION['user']['userphoto'] ?? ''; // path or filename stored in DB

// Determine user image
$userImage = !empty($userphoto) && file_exists("$userphoto") ? "$userphoto" : "uploads/users/user.png";
?>

<header class="d-flex justify-content-between align-items-center px-3 py-2" style="background:#008c8c; color:#fff;">
    <!-- Logo / Brand -->
    <div class="d-flex align-items-center gap-2">
        <img src="images/logo.png" alt="Logo" style="height:35px;">
        <strong>Flash Courier</strong>
    </div>

    <!-- Right section -->
    <div class="d-flex align-items-center gap-3" style="font-size:0.9em;">
        <!-- User avatar -->
        <div class="d-flex align-items-center gap-2">
            <img src="<?= htmlspecialchars($userImage) ?>" alt="User" 
                 style="width:40px; height:40px; border-radius:50%; border:2px solid #fff; object-fit:cover;">
            <div>
                <?= htmlspecialchars($username) ?><br>
                <small><?= htmlspecialchars(ucfirst($role)) ?></small>
            </div>
        </div>

        <!-- Menu dropdown -->
        <div class="dropdown">
            <a class="btn btn-sm btn-outline-light dropdown-toggle" href="#" role="button" 
               id="menuDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                Menu
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="menuDropdown">
                <li><a class="dropdown-item" href="dashboard.php">Dashboard</a></li>
                <li><a class="dropdown-item" href="arrival_ack.php">receiving end</a></li>
                
                
                 <li><a class="dropdown-item" href="logs.php">activity logs</a></li>
                <li><a class="dropdown-item" href="users.php">Users</a></li>
                <li><a class="dropdown-item" href="reportkuriye.php">Report</a></li>
                <li><a class="dropdown-item" href="logout.php">Sign out</a></li>
            </ul>
        </div>
    </div>
</header>
