<?php
require_once __DIR__ . '/app/functions.php';
require_once __DIR__ . '/app/auth.php';

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = trim($_POST['username'] ?? '');
    $p = trim($_POST['password'] ?? '');

    if (attempt_login($u, $p)) {
        header('Location: dashboard.php');
        exit;
    } else {
        $err = 'Invalid credentials';
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Login - Flash Courier</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>

<body class="d-flex flex-column min-vh-100" style="background:#f5f7fa;">

    <div class="container my-auto">
        <div class="row justify-content-center">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card shadow p-4 border-0">
                    <h3 class="text-center mb-3" style="color:#008c8c;">Flash Courier — Login</h3>

                    <?php if ($err): ?>
                        <div class="alert alert-danger text-center">
                            <?= htmlspecialchars($err) ?>
                        </div>
                    <?php endif; ?>

                    <form method="post">
                        <div class="mb-3">
                            <input name="username" class="form-control" placeholder="Username" required autofocus>
                        </div>
                        <div class="mb-3">
                            <input name="password" type="password" class="form-control" placeholder="Password" required>
                        </div>
                        <button class="btn w-100 text-white" style="background:#008c8c;">Login</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php include 'footer.php'; ?>
</body>
</html>
