<?php
session_start();
require_once __DIR__ . '/app/functions.php';
require_login();

$uid = current_user_id();
$username = $_SESSION['user']['username'] ?? 'Unknown';
$role = $_SESSION['user']['role'] ?? 'user';
$userphoto = $_SESSION['user']['userphoto'] ?? '';
$userImage = !empty($userphoto) && file_exists("uploads/$userphoto") ? "uploads/$userphoto" : "images/user.png";

$pdo = db();

// Date filters
$from = $_GET['from'] ?? date('Y-m-01');
$to = $_GET['to'] ?? date('Y-m-d');

// Build query
$sql = "SELECT l.*, u.username 
        FROM logs l 
        JOIN users u ON l.user_id = u.id 
        WHERE l.created_at BETWEEN :from AND :to";

$params = [':from' => $from . ' 00:00:00', ':to' => $to . ' 23:59:59'];

// Restrict non-admin users
if ($role !== 'admin') {
    $sql .= " AND l.user_id = :uid";
    $params[':uid'] = $uid;
}

$sql .= " ORDER BY l.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Activity Logs - Flash Courier</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body { background:#f8f9fa; font-size:14px; }
header { background:#008c8c; color:#fff; }
.table th { white-space:nowrap; }
</style>
</head>
<body>

<!-- Header -->
<?php include("header.php"); ?>

<div class="container-fluid mt-3">
    <div class="card">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0">System Activity Logs</h5>
        </div>
        <div class="card-body">
            <!-- Filter -->
            <form class="row g-2 mb-3" method="get">
                <div class="col-auto">
                    <label>From:</label>
                    <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control form-control-sm">
                </div>
                <div class="col-auto">
                    <label>To:</label>
                    <input type="date" name="to" value="<?= htmlspecialchars($to) ?>" class="form-control form-control-sm">
                </div>
                <div class="col-auto align-self-end">
                    <button type="submit" class="btn btn-sm btn-primary">Filter</button>
                </div>
            </form>

            <!-- Logs Table -->
            <div class="table-responsive">
                <table class="table table-sm table-bordered table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <?php if($role === 'admin'): ?><th>User</th><?php endif; ?>
                            <th>Action</th>
                            <th>Detail</th>
                            <th>IP</th>
                            <th>User Agent</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($logs)): ?>
                            <tr><td colspan="<?= $role === 'admin' ? 7 : 6 ?>" class="text-center text-muted">No logs found</td></tr>
                        <?php else: ?>
                            <?php foreach($logs as $i => $log): ?>
                            <tr>
                                <td><?= $i + 1 ?></td>
                                <?php if($role === 'admin'): ?><td><?= htmlspecialchars($log['username']) ?></td><?php endif; ?>
                                <td><?= htmlspecialchars($log['action']) ?></td>
                                <td><?= htmlspecialchars($log['detail']) ?></td>
                                <td><?= htmlspecialchars($log['ip']) ?></td>
                                <td style="max-width:200px; overflow:hidden; text-overflow:ellipsis;">
                                    <?= htmlspecialchars($log['ua']) ?>
                                </td>
                                <td><?= htmlspecialchars($log['created_at']) ?></td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
<?php  include 'footer.php'; ?>

</html>
