<?php
require_once __DIR__.'/app/functions.php';
require_login();
$input = json_decode(file_get_contents('php://input'), true);
$id = $input['id'] ?? '';
$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM couriers WHERE id=?');
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$row) { echo json_encode(['ok'=>false,'error'=>'Not found']); exit; }
$message = "Flash Courier: Dear {$row['recipient_name']}, your parcel with code {$row['id']} is ready for pickup.";
$res = send_sms_newsoap($row['recipient_phone'],$message);
log_action(current_user_id(),'notify', json_encode(['id'=>$id,'sms'=>$res]));
echo json_encode($res);
