<?php
require_once __DIR__.'/app/functions.php';
require_login();
$id = $_GET['id'] ?? '';
$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM couriers WHERE id=?');
$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$row) exit('Not found');
log_action(current_user_id(),'print',"print_id:$id");
?><!doctype html>
<html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Receipt <?=htmlspecialchars($row['id'])?></title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>.receipt{width:320px;padding:8px;font-family:monospace}</style>
</head><body>
<div class="receipt">
  <div style="text-align:center"><strong>Flash Courier</strong></div>
  <div>Code: <strong><?=htmlspecialchars($row['id'])?></strong></div>
  <div>Recipient: <?=htmlspecialchars($row['recipient_name'])?> - <?=htmlspecialchars($row['recipient_phone'])?></div>
  <div>Sender: <?=htmlspecialchars($row['sender_name'])?> - <?=htmlspecialchars($row['sender_phone'])?></div>
  <div>Amount: <?=htmlspecialchars($row['amount'])?></div>
  <div>Note: <?=htmlspecialchars($row['note'])?></div>
  <svg id="barcode"></svg>
  <canvas id="qrcode" style="margin-top:6px"></canvas>
</div>
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
<script>JsBarcode(document.getElementById('barcode'),'<?=htmlspecialchars($row['id'])?>',{format:'CODE128',width:1,height:40,displayValue:true}); new QRious({element:document.getElementById('qrcode'),value:'<?=htmlspecialchars($row['id'])?>',size:160}); window.print();</script>
</body></html>
