<?php
session_start();
require_once __DIR__.'/app/functions.php';
require_login();

$pdo = db();
$role = $_SESSION['user']['role'] ?? 'user';
$username = $_SESSION['user']['username'] ?? '';

if($role !== 'admin'){
    echo "<h3 class='text-danger text-center mt-5'>Access Denied. Admins only.</h3>";
    exit;
}

// Handle add user
if(isset($_POST['add_user'])){
    $username = trim($_POST['username']);
    $fullname = trim($_POST['fullname']);
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);
    $location_id = $_POST['location_id'];
    $role_user = $_POST['role'];
    $active = 'YES';
    $desabled = 'NO';

    $imagePath = '';
    if(!empty($_FILES['userphoto']['name'])){
        $targetDir = "uploads/users/";
        if(!file_exists($targetDir)) mkdir($targetDir, 0777, true);
        $filename = time().'_'.basename($_FILES['userphoto']['name']);
        $targetFile = $targetDir.$filename;
        if(move_uploaded_file($_FILES['userphoto']['tmp_name'], $targetFile)){
            $imagePath = $targetFile;
        }
    }

    $stmt = $pdo->prepare("INSERT INTO users (created_at, username, fullname, password_hash, location_id, role, userphoto, active, desabled)
                           VALUES (NOW(),?,?,?,?,?,?,?,?)");
    $stmt->execute([$username, $fullname, $password, $location_id, $role_user, $imagePath, $active, $desabled]);
    $msg = "User added successfully.";
}

// Handle user status updates
if(isset($_GET['action'], $_GET['id'])){
    $id = intval($_GET['id']);
    $action = $_GET['action'];

    if($action === 'activate'){
        $pdo->prepare("UPDATE users SET active='YES' WHERE id=?")->execute([$id]);
    } elseif($action === 'deactivate'){
        $pdo->prepare("UPDATE users SET active='NO' WHERE id=?")->execute([$id]);
    } elseif($action === 'disable'){
        $pdo->prepare("UPDATE users SET desabled='YES' WHERE id=?")->execute([$id]);
    }
    header("Location: users.php");
    exit;
}

// Fetch locations for dropdown
$locations = $pdo->query("SELECT id, name FROM locations ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// Fetch all users
$users = $pdo->query("SELECT u.*, l.name AS location_name FROM users u 
                      LEFT JOIN locations l ON u.location_id = l.id 
                      ORDER BY u.id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>Manage Users - Flash Courier</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<style>
body { background:#f8f9fa; font-size:14px; }
img.user-img { width:45px; height:45px; border-radius:50%; object-fit:cover; border:1px solid #ccc; }
.status-active { color:green; font-weight:bold; }
.status-inactive { color:orange; font-weight:bold; }
.status-disabled { color:red; font-weight:bold; }
header {
    background-color:#007b83;
    color:white;
    padding:10px 20px;
    border-radius:5px;
    margin-bottom:20px;
}
.dropdown-menu a { font-size:14px; }
</style>
</head>
<body>

<!-- Header -->
  <?php include("header.php"); ?>

<div class="container">
    <h4 class="mb-3">👥 User Management</h4>
    <?php if(!empty($msg)): ?>
        <div class="alert alert-success"><?=$msg?></div>
    <?php endif; ?>

    <!-- Add User -->
    <div class="card mb-3">
        <div class="card-header bg-info text-white">Add New User</div>
        <div class="card-body">
            <form method="POST" enctype="multipart/form-data" class="row g-2">
                <div class="col-md-3"><input type="text" name="username" class="form-control form-control-sm" placeholder="Username" required></div>
                <div class="col-md-3"><input type="text" name="fullname" class="form-control form-control-sm" placeholder="Full Name" required></div>
                <div class="col-md-2"><input type="password" name="password" class="form-control form-control-sm" placeholder="Password" required></div>
                <div class="col-md-2">
                    <select name="location_id" class="form-control form-control-sm" required>
                        <option value="">Select Location</option>
                        <?php foreach($locations as $loc): ?>
                            <option value="<?=$loc['id']?>"><?=$loc['name']?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="role" class="form-control form-control-sm" required>
                        <option value="user">User</option>
                        <option value="admin">Admin</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <input type="file" name="userphoto" class="form-control form-control-sm" accept="image/*">
                </div>
                <div class="col-md-12 text-end mt-2">
                    <button type="submit" name="add_user" class="btn btn-success btn-sm">➕ Add User</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Users Table -->
    <div class="card">
        <div class="card-header bg-secondary text-white">Registered Users</div>
        <div class="table-responsive">
            <table class="table table-bordered table-sm align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Photo</th>
                        <th>Username</th>
                        <th>Full Name</th>
                        <th>Location</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($users as $u): ?>
                    <tr>
                        <td><?=$u['id']?></td>
                        <td><img src="<?= $u['userphoto'] && file_exists($u['userphoto']) ? $u['userphoto'] : 'images/user.png' ?>" class="user-img"></td>
                        <td><?=$u['username']?></td>
                        <td><?=$u['fullname']?></td>
                        <td><?=$u['location_name']?></td>
                        <td><?=$u['role']?></td>
                        <td>
                            <?php 
                            if($u['desabled']=='YES') echo "<span class='status-disabled'>Disabled</span>";
                            else echo $u['active']=='YES' ? "<span class='status-active'>Active</span>" : "<span class='status-inactive'>Inactive</span>";
                            ?>
                        </td>
                        <td>
                            <?php if($u['desabled']=='NO'): ?>
                                <?php if($u['active']=='NO'): ?>
                                    <a href="?action=activate&id=<?=$u['id']?>" class="btn btn-success btn-sm">Activate</a>
                                <?php else: ?>
                                    <a href="?action=deactivate&id=<?=$u['id']?>" class="btn btn-warning btn-sm">Deactivate</a>
                                <?php endif; ?>
                                <a href="?action=disable&id=<?=$u['id']?>" class="btn btn-danger btn-sm">Disable</a>
                            <?php else: ?>
                                <span class="text-danger">Permanently Disabled</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
